SET SESSION AUTHORIZATION 'DEMODATA';

---    Stammdaten
DO $$
  DECLARE
    art_welle                     VARCHAR := 'W.13.N-999.999/TEST';
    my_wz_art_nr                  VARCHAR := 'W-9999-SF.99MM/TEST';
    myop_ix                       INTEGER;
    myo2_txt                      TEXT;
    myid                          INTEGER;
    myo5_txt                      TEXT;
    ---
 BEGIN

    SELECT nextval('opl_op_ix_seq') INTO myop_ix;

    PERFORM tartikel.art__ak_nr__delete(my_wz_art_nr);
    PERFORM tartikel.art__ak_nr__delete(art_welle);

    --- Artikel anlegen
    INSERT INTO art (ak_ac   , ak_fertigung, ak_nr   , ak_bez     , ak_mat   , ak_dim     , ak_din  , ak_znr   , ak_idx, ak_standard_mgc, ak_bfr, ak_vkprund, ak_pknr, ak_nrhl  , insert_by   , insert_date )
    VALUES          ('PR1001', true        , art_welle, 'Welle Nut', '115CrV3', 'Ø13x37 mm', '1.2210', '272.371', NULL  , 1              , 25    , 0.01      , 1      , art_welle , current_user, current_date);

    --- Werkzeug-Artikel anlegen
    INSERT INTO artcod (ac_n    , ac_i, ac_b       )
    SELECT              'WKZ.FR', 1   , 'Werkzeuge'
    WHERE NOT EXISTS(SELECT TRUE FROM artcod WHERE ac_n = 'WKZ.FR');

    INSERT INTO art (ak_ac   , ak_fertigung, ak_nr        , ak_bez              , ak_mat, ak_dim , ak_standard_mgc, insert_by   , insert_date )
    VALUES          ('WKZ.FR', false        , my_wz_art_nr, 'Schaftfräser 12 mm', NULL  , '99 mm', 1              , current_user, current_date);

    --- AVOR-Stammkarte anlegen
    INSERT INTO opl (op_n    , op_ix  , op_vi, op_lg, insert_by   , insert_date )
    VALUES          (art_welle, myop_ix, '1'  , 6    , current_user, current_date);

    --- Arbeitsgänge anlegen

    ----- AG 10
    myo2_txt := 'Sägen';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr  , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 10  , myo2_txt, 2          , 2          , 'SAG-002', true , 15.0000, 900.0000 , 0.2500, 15.0000  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

    --- AG 10 - Arbeitsschritte
    myo5_txt     := 'Sägen';
    INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
    VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, 15   , 0.02, current_user, current_date);
    ---
    -----

    ----- AG 20
    myo2_txt := 'Schruppen (Plan)
    Schruppen (Kontur grob)
    Schruppen (Kontur fein)
    Schruppen (offene Nut 1 von 4)
    Schruppen (offene Nut 2 von 4)
    Schruppen (offene Nut 3 von 4)
    Schruppen (offene Nut 4 von 4)';

    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr  , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 20  , myo2_txt, 2          , 2          , 'FRA-001', true , 30.0000, 1800.0000, 7.1040, 426.2400 , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 20 - Arbeitsschritte
      myo5_txt     := 'Schruppen (Plan)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, 30   , 2.18, current_user, current_date);

      myo5_txt     := 'Schruppen (Kontur grob)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 2.18, current_user, current_date);

      myo5_txt     := 'Schruppen (Kontur fein)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 2.18, current_user, current_date);

      myo5_txt     := 'Schruppen (offene Nut 1 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 40     , myo5_txt, my_wz_art_nr, NULL , 0.14, current_user, current_date);

      myo5_txt     := 'Schruppen (offene Nut 2 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 50     , myo5_txt, my_wz_art_nr, NULL , 0.14, current_user, current_date);

      myo5_txt     := 'Schruppen (offene Nut 3 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 60     , myo5_txt, my_wz_art_nr, NULL , 0.14, current_user, current_date);

      myo5_txt     := 'Schruppen (offene Nut 4 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 70     , myo5_txt, my_wz_art_nr, NULL , 0.14, current_user, current_date);
     ---
    -----

    ----- AG 30
    myo2_txt := 'Schlichten Außenkontur rechts
    Schlichten Außenkontur links
    Schlichten Außenkontur vorn (Zapfen)
    Schlichten Außenkontur hinten
    Nut fräsen vor Zapfen
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th  , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 30  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 11.9577, 717.4620 , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;


     --- AG 30 - Arbeitsschritte
      myo5_txt     := 'Schlichten Außenkontur rechts';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 2.72, current_user, current_date);

      myo5_txt     := 'Schlichten Außenkontur links';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 2.72, current_user, current_date);

      myo5_txt     := 'Schlichten Außenkontur vorn (Zapfen)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 2.72, current_user, current_date);

      myo5_txt     := 'Schlichten Außenkontur hinten';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 40     , myo5_txt, my_wz_art_nr, NULL , 2.72, current_user, current_date);

      myo5_txt     := 'Nut fräsen vor Zapfen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 50     , myo5_txt, my_wz_art_nr, NULL , 1.07, current_user, current_date);
     ---
    -----

    ----- AG 40
    myo2_txt := 'Nut fräsen hinter Zapfen';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 40  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 1.5850, 95.1000  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 40 - Arbeitsschritte
      myo5_txt     := 'Nut fräsen hinter Zapfen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 1.59, current_user, current_date);
     ---
    -----

    ----- AG 50
    myo2_txt := 'Radien schlichten (Radius 1 mm fräsen)';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 50  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.1289, 7.7340   , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 50 - Arbeitsschritte
      myo5_txt     := 'Radien schlichten (Radius 1 mm fräsen)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 1.59, current_user, current_date);
     ---
    -----

    ----- AG 60
    myo2_txt := 'Radius 1mm fräsen (offene Nut 1 von 4)
    Radius 1mm fräsen (offene Nut 2 von 4)
    Radius 1mm fräsen (offene Nut 3 von 4)
    Radius 1mm fräsen (offene Nut 4 von 4)
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 60  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.2219, 13.3140  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 60 - Arbeitsschritte
      myo5_txt     := 'Radius 1mm fräsen (offene Nut 1 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);

      myo5_txt     := 'Radius 1mm fräsen (offene Nut 2 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);

      myo5_txt     := 'Radius 1mm fräsen (offene Nut 3 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);

      myo5_txt     := 'Radius 1mm fräsen (offene Nut 4 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 40     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);
     ---
    -----

    ----- AG 70
    myo2_txt := 'Radien 2mm fräsen hinter Zapfen
    Radien 2mm fräsen vorn
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 70  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.2903, 17.4180  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 70 - Arbeitsschritte
      myo5_txt     := 'Radien 2mm fräsen hinter Zapfen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.15, current_user, current_date);

      myo5_txt     := 'Radien 2mm fräsen vorn';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.15, current_user, current_date);
     ---
    -----

    ----- AG 80
    myo2_txt := 'Gewindebohren
    Gewindefräsen
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 80  , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.5631, 33.7860  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 80 - Arbeitsschritte
      myo5_txt     := 'Gewindebohren';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);

      myo5_txt     := 'Gewindefräsen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.06, current_user, current_date);
     ---
    -----

    ----- AG 90
    myo2_txt := 'Aufspannungswechsel
    Schruppen (plan)
    Schlichten Innenkontur
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr  , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 90  , myo2_txt, 2          , 2          , 'FRA-001', true , 30.0000, 0.0000   , 2.8023, 168.1380 , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 90 - Arbeitsschritte
      myo5_txt     := 'Aufspannungswechsel';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.0, current_user, current_date);

      myo5_txt     := 'Schruppen (plan)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 1.63, current_user, current_date);

      myo5_txt     := 'Schlichten Innenkontur';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 1.170, current_user, current_date);
     ---
    -----

    ----- AG 100
    myo2_txt := 'Radien schlichten (Radius 1mm offene Nut 1 von 4)
    Radien schlichten (Radius 1mm offene Nut 2 von 4)
    Radien schlichten (Radius 1mm offene Nut 3 von 4)
    Radien schlichten (Radius 1mm offene Nut 4 von 4)
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 100 , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.2968, 17.8080  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 100 - Arbeitsschritte
      myo5_txt     := 'Radien schlichten (Radius 1mm offene Nut 1 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.07, current_user, current_date);

      myo5_txt     := 'Radien schlichten (Radius 1mm offene Nut 2 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.07, current_user, current_date);

      myo5_txt     := 'Radien schlichten (Radius 1mm offene Nut 3 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 30     , myo5_txt, my_wz_art_nr, NULL , 0.07, current_user, current_date);

      myo5_txt     := 'Radien schlichten (Radius 1mm offene Nut 4 von 4)';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 40     , myo5_txt, my_wz_art_nr, NULL , 0.07, current_user, current_date);
     ---
    -----

    ----- AG 110
    myo2_txt := 'Fase fräsen Außenseite';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 110 , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 1.0820, 64.9200  , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 110 - Arbeitsschritte
      myo5_txt     := 'Fase fräsen Außenseite';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 1.08, current_user, current_date);
     ---
    -----

    ----- AG 120
    myo2_txt := 'Aufspannungswechsel
    Zapfen fräsen
    ';
    INSERT INTO op2 (o2_ix  , o2_n, o2_txt  , o2_zeinh_tr, o2_zeinh_tx, o2_ks , o2_as, o2_tr , o2_tr_sek, o2_th , o2_th_sek, o2_tm , o2_tm_sek, o2_tn , o2_tn_sek, insert_by   , insert_date )
    VALUES          (myop_ix, 120 , myo2_txt, 2          , 2          , 'FRA-001', true , 0.0000, 0.0000   , 0.0818, 4.9080   , 0.0000, 0.0000   , 0.0000, 0.0000   , current_user, current_date)
    RETURNING o2_id INTO myid;

     --- AG 120 - Arbeitsschritte
      myo5_txt     := 'Aufspannungswechsel';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 10     , myo5_txt, my_wz_art_nr, NULL , 0.00, current_user, current_date);

      myo5_txt     := 'Zapfen fräsen';
      INSERT INTO op5 (o5_o2_id, o5_asnr, o5_txt  , o5_wz_aknr  , o5_tr, o5_th, insert_by   , insert_date)
      VALUES          (myid    , 20     , myo5_txt, my_wz_art_nr, NULL , 0.03, current_user, current_date);
     ---
    -----
 END $$ LANGUAGE plpgsql;
--- Strammdaten Ende


--Warenwirtschaft: Standardprozess: Verkauf (Rahmen und Abruf) > PA > ABK, Lager
DO $$
    DECLARE
        s VARCHAR;
        myident                                 VARCHAR:=current_user;
        --Datum --TODO: ACHTUNG ALLE DATUM: ABFANGEN DAS AUF WOCHENENDE
            dat_folgejahr                       DATE:= current_date + interval '1 year';
            dat_monat_folgemonat_erster         DATE:=(SELECT date_trunc('month', current_date + interval '1 month')); --  01. des Folgemonats --achtung dat_current_plus_1_monat
            dat_current_minus_2_monat           DATE:=current_date - interval '2 month';
            dat_current_minus_1_monat           DATE:=current_date - interval '1 month';
            dat_current_minus_1_week            DATE:=current_date - interval '1 week';
            dat_current_minus_5_day             DATE:=current_date-5;
            dat_current_plus_15_day             DATE:=current_date+15;
            dat_current_plus_1_monat            DATE:=current_date + interval '1 month'; --achtung dat_monat_folgemonat_erster
        --Artikel
            art_welle                           VARCHAR :='W.13.N-999.999/TEST';
            art_welle_mgcid                     INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle);
            art_welle_mgcid_iso_palt_10         VARCHAR :='Stk';
            art_welle_mgcid_palt_10             INTEGER:=tartikel.me__art__artmgc__m_id__by__me_iso(art_welle, art_welle_mgcid_iso_palt_10);

        --Adressen
            adk_kunde_auto                      VARCHAR :='AUTO-AG';
            adk_kunde_getr                      VARCHAR :='GETRIEBE-GMBH';
            adk_lief_elek                       VARCHAR :='ELEKTR';
            adk_lief_zersp                      VARCHAR :='ZERSP';
            adk_lief_stahl                      VARCHAR :='STAHL';
        --Sonstiges
            steu_steucode_auftg                 INTEGER :=TSystem.Settings__Get('auftgsteucode');
            rahmen_ident                        VARCHAR :='RAH-0011';
        --Verkauf
            auftg_rahmen_ag_id                  INTEGER; --zuweisen durch returning bei insert into auftg

            auftg_welle_ag_id_plus15            INTEGER;
        --Einkauf, ABK
            ldsdoki_welle_ld_id_plus15          INTEGER;
            ldsdoki_welle_abix_plus15           INTEGER;

            ldsdoke_dbrid                       VARCHAR(32);
            ldsdoke_ld_auftg                VARCHAR(30);
            ldsdoke_erg_nr                      VARCHAR(30);
            ldsdoke_ltd_dokunr                  INTEGER;

            ldsdoke_sernrident                  VARCHAR := 'SERNR-'||current_date;
            auftg_welle_ag_id_palt10            INTEGER;
        --Materialeinkauf
          mat_aknr                          VARCHAR(40)     := 'W-9999-SF.99MM/TEST';
            mat_bez                           VARCHAR       := '115CrV3';
            mat_ld_auftg                    VARCHAR(30);
            mat_preis                         NUMERIC;
            kg_mgcode_me_cod                  INTEGER;
            kg_ld_ekp_mce                   INTEGER;
            s3m_mgcode_me_cod                 INTEGER;
            s3m_ld_ekp_mce                    INTEGER;
            mat_stk                           INTEGER;
            mat_ld_id                       INTEGER;
            mat_lifsch_dbrid                  VARCHAR(32);
            mat_beld_dokunr                     VARCHAR(30);
            mat_be_bnr                        VARCHAR(15);
            mat_lfs_pos_id                    INTEGER;
            mat_pos                         INTEGER;
            mat_ltd_dokunr                    INTEGER;
            mat_erg_nr                        VARCHAR(30);
            mat_wendat_dbrid                  INTEGER;

        --- Verkauf.
            mat_ag_nr                       VARCHAR(30);
            mat_ag_preis                    NUMERIC;  -- Verkaufspreis
            mat_ag_id                       NUMERIC;
            stk_mgcode_me_cod                 INTEGER;
            stk_ld_ekp_mce                    INTEGER;
            p10_mgcode_me_cod                 INTEGER;
            p10_ld_ekp_mce                    INTEGER;
        --- Anfrageverwaltung
            akbtxt                        TEXT;
            akbtxtrtf                     TEXT;
            aang_alief_id                 INTEGER;
            aang_aart_id                  INTEGER;
            aang_steucode1                  INTEGER;
            aang_steuproz1                  NUMERIC(5,2);
            anfnr                         VARCHAR;
            aAng__id                            INTEGER;
    BEGIN

    --- Mengeneinheiten holen
          kg_mgcode_me_cod := (SELECT COALESCE(me_cod, 0) FROM mgcode WHERE me_bez LIKE 'Kilogramm');
          IF COALESCE(kg_mgcode_me_cod, 0) = 0 THEN
            INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (2, 'kg', 'Kilogramm')
            RETURNING me_cod INTO kg_mgcode_me_cod;
          END IF;
          kg_ld_ekp_mce := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = mat_aknr AND m_mgcode = kg_mgcode_me_cod);
          IF COALESCE(kg_ld_ekp_mce, 0) = 0 THEN
            INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (mat_aknr, kg_mgcode_me_cod, '1.2')
            RETURNING m_id INTO kg_ld_ekp_mce;
          END IF;

          s3m_mgcode_me_cod := (SELECT COALESCE(me_cod, 0) FROM mgcode WHERE me_bez LIKE 'Stange 3 Meter');
          IF COALESCE(s3m_mgcode_me_cod, 0) = 0 THEN
            INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (50, 'St 3m', 'Stange 3 Meter')
            RETURNING me_cod INTO s3m_mgcode_me_cod;
          END IF;
          s3m_ld_ekp_mce := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = mat_aknr AND m_mgcode = s3m_mgcode_me_cod);
          IF COALESCE(s3m_ld_ekp_mce, 0) = 0 THEN
            INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (mat_aknr, s3m_mgcode_me_cod, '0.3333')
            RETURNING m_id INTO s3m_ld_ekp_mce;
          END IF;

          stk_mgcode_me_cod := (SELECT COALESCE(me_cod, 0) FROM mgcode WHERE me_bez LIKE 'Stück');
          IF COALESCE(stk_mgcode_me_cod, 0) = 0 THEN
            INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (1, 'Stk', 'Stück')
            RETURNING me_cod INTO stk_mgcode_me_cod;
          END IF;
          stk_ld_ekp_mce := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = mat_aknr AND m_mgcode = stk_mgcode_me_cod);
          IF COALESCE(stk_ld_ekp_mce, 0) = 0 THEN
            INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (mat_aknr, stk_mgcode_me_cod, '0.2')
            RETURNING m_id INTO stk_ld_ekp_mce;
          END IF;

          p10_mgcode_me_cod := kg_mgcode_me_cod; -- 'Kilogramm'
          p10_ld_ekp_mce := (SELECT COALESCE(m_id, 0) FROM artmgc WHERE m_ak_nr = art_welle AND m_mgcode = p10_mgcode_me_cod);
          IF COALESCE(p10_ld_ekp_mce, 0) = 0 THEN
            INSERT INTO artmgc (m_ak_nr, m_mgcode, m_uf) VALUES (art_welle, p10_mgcode_me_cod, '0.1')
            RETURNING m_id INTO p10_ld_ekp_mce;
          END IF;
     --Konstanten-Initialisierungen
    --VERKAUF
      --Verkaufsaufträge
         S:=getnumcirclenr('eauftg');

    -------------------------------------------------------------------------------------

     ----- Einkauf 'I' erstellen : Produktionsaufträge, ABK erstellen -----
       -- Interne Fertigung der ersten 22 teile für Kundenauftrag "GETRIEBE-GMBH bestellt 52 Ersatzteile "Welle" zum 01. des Folgemonats", Rückwärts terminiert
        --ldsdoki_welle_ld_id_plus15
            INSERT INTO ldsdok
              (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_stk_soll, ld_term, ld_ag_id, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
             SELECT
              'I', (TEinkauf.Generate_Bestellnummer_Ext('I', ag_id)).nummer, 1, '#', ag_aknr, ag_stk+5, ag_stk, ag_aldatum, ag_id, ag_mcv, myident, 9, 19
             FROM auftg WHERE ag_id=auftg_welle_ag_id_plus15
             RETURNING ld_id INTO ldsdoki_welle_ld_id_plus15;

       -- Freien Produktionsauftrag auf Lager Welle current_date, Vorwärts terminiert
            INSERT INTO ldsdok
              (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_stk_soll, ld_term, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
             SELECT
              'I', (TEinkauf.Generate_Bestellnummer_Ext('I')).nummer, 1, '#', art_welle, 70, 65, current_date, art_welle_mgcid, myident, 9, 19
             RETURNING ld_id INTO s;
       -- Freien Produktionsauftrag auf Lager Welle dat_current_plus_1_monat, Rückwärts terminiert
            INSERT INTO ldsdok
              (ld_code, ld_auftg, ld_pos, ld_kn, ld_aknr, ld_stk, ld_stk_soll, ld_term, ld_mce, ld_ekref, ld_steucode, ld_steuproz)
             SELECT
              'I', (TEinkauf.Generate_Bestellnummer_Ext('I')).nummer, 1, '#', art_welle, 215, 205, dat_current_plus_1_monat, art_welle_mgcid, myident, 9, 19
             RETURNING ld_id INTO s;
    ---------------------------------------------------------------------------------
    --LAGER
     --Lagerzugang für SerNr-Bestellung ldsdoke_sernrident

      -- Lager Zu-/ Abgänge 'art_welle' 'Palette 10'
    -- Lagerzugang 5 'Palette 10'
     INSERT INTO wendat (w_l_krz, w_aknr   , w_zug_dat   , w_lgort, w_lagort, w_lgchnr, w_zugang, w_zug_mec                                        )
         VALUES
          ('#'    , art_welle, current_date, 'WE'   ,'WE'     , 'TEST 1', 5       , tartikel.me__art__artmgc__m_id__by__me_iso(art_welle, art_welle_mgcid_iso_palt_10));

     -- Lagerabgang 5 Stück
     INSERT INTO lifsch
          (l_ag_id                 , l_krz, l_krzl, l_krzf, l_aknr  , l_ldat       , l_lgort, l_lgchnr, l_abg_mec                , l_abgg, l_inliefdok, l_dofakt)
         VALUES
          (auftg_welle_ag_id_palt10, '#'  , '#'   , '#'   , art_welle, current_date, 'WE'   , 'TEST'  , tartikel.me__art__artmgc__m_id__by__me_iso(art_welle, 'Stk'), 5     , False      , True    );

     -- Lagerabgang 1 'Palette 10'
     INSERT INTO lifsch
          (l_ag_id                 , l_krz, l_krzl, l_krzf, l_aknr  , l_ldat      , l_lgort, l_lgchnr, l_abg_mec                                          , l_abgg, l_inliefdok, l_dofakt)
         VALUES
          (auftg_welle_ag_id_palt10, '#'  , '#'   , '#'   , art_welle, current_date, 'WE'   , 'TEST' , tartikel.me__art__artmgc__m_id__by__me_iso(art_welle, art_welle_mgcid_iso_palt_10), 1     , False      , True    );
    -------------------------------------------------------------------------------------

    --- Materialbestellung und Auftrag
     --- Einkauf '1.2210 Ø14X1000'
       mat_ld_auftg   := (TEinkauf.Generate_Bestellnummer_Ext('E')).nummer;
       mat_pos    := TSystem.Settings__GetInteger('LD_POS_WIDTH');
    --- Eingangsrechnungsnummer
       mat_erg_nr := getnumcirclenr('eingrechnr');
    --- Dokument für Einkaufposition anlegen
       mat_ltd_dokunr := nextval('ldsdok_ld_dokunr_seq');
     ---
       --- Variante 1: ld_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc, ld_ekp_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc
       --- Bestellung
           mat_stk := 12;
           mat_preis  := 10;
           INSERT INTO ldsdok
             (ld_dokunr     , ld_code, ld_auftg    , ld_pos ,  ld_kn  , ld_aknr , ld_stk    , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce                   , ld_steucode, ld_steuproz, ld_ekp_mce               , insert_by, insert_date)
           VALUES
             (mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos,  'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 9          , 19         , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
           RETURNING ld_id INTO mat_ld_id;
           mat_pos := mat_pos + TSystem.Settings__GetInteger('LD_POS_WIDTH');
       --- Lagerzungang
         INSERT INTO wendat
           (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang   , w_zug_mec                , insert_by, insert_date)
         VALUES
           (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
         RETURNING dbrid INTO mat_wendat_dbrid;

       --- EingagsrechnungKopf anlegen
         PERFORM TBeleg.EingrechDokumentFromWendat(mat_wendat_dbrid, mat_erg_nr);

       --- Eingangsrechnungsposition anlegen
         PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);
       --- Variante 1. Ende

     --- Variante 2: ld_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc, ld_ekp_mce = s3m_ld_ekp_mce
       mat_stk := 12;
       mat_preis  := 30;
         INSERT INTO ldsdok
           (ld_dokunr     , ld_code, ld_auftg    , ld_pos , ld_kn  , ld_aknr , ld_stk    , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce                    , ld_steucode, ld_steuproz, ld_ekp_mce    , insert_by, insert_date)
         VALUES
           (mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos, 'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 9          , 19         , s3m_ld_ekp_mce, current_user, current_date)
         RETURNING ld_id INTO mat_ld_id;

         mat_pos  := mat_pos + TSystem.Settings__GetInteger('LD_POS_WIDTH');

      --- Lagerzungang
       INSERT INTO wendat
         (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang  , w_zug_mec                , insert_by, insert_date)
       VALUES
         (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
       RETURNING dbrid INTO mat_wendat_dbrid;

      --- Eingangsrechnungsposition anlegen
        PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);
      --- Variante 2. Ende

     --- Variante 3: ld_mce = s3m_ld_ekp_mce, ld_ekp_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc
       --- Bestellung
         mat_stk := 4;
         mat_preis  := 10;
           INSERT INTO ldsdok
             (ld_dokunr     , ld_code, ld_auftg    , ld_pos , ld_kn  , ld_aknr , ld_stk    , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce        , ld_steucode, ld_steuproz, ld_ekp_mce               , insert_by, insert_date)
           VALUES
             (mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos, 'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , s3m_ld_ekp_mce, 9          , 19         , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
         RETURNING ld_id INTO mat_ld_id;

         mat_pos  := mat_pos + TSystem.Settings__GetInteger('LD_POS_WIDTH');
       --- Lagerzungang
            INSERT INTO wendat
            (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang  , w_zug_mec     , insert_by, insert_date)
          VALUES
            (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk, s3m_ld_ekp_mce, current_user, current_date)
          RETURNING dbrid INTO mat_wendat_dbrid;

       --- Eingangsrechnungsposition anlegen
         PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);
       --- Variante 3. Ende

     --- Variante 4: ld_mce = s3m_ld_ekp_mce, ld_ekp_mce = kg_ld_ekp_mce
       --- Bestellung
         mat_stk := 4;
         mat_preis  := 8.3333;
           INSERT INTO ldsdok
             (ld_dokunr     , ld_code, ld_auftg    , ld_pos , ld_kn  , ld_aknr , ld_stk    , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce        , ld_steucode, ld_steuproz, ld_ekp_mce   , insert_by, insert_date)
           VALUES
             (mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos, 'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , s3m_ld_ekp_mce, 9          , 19         , kg_ld_ekp_mce, current_user, current_date)
         RETURNING ld_id INTO mat_ld_id;

       --- Lagerzungang
           INSERT INTO wendat
           (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang , w_zug_mec      , insert_by, insert_date)
         VALUES
           (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk, s3m_ld_ekp_mce, current_user, current_date)
         RETURNING dbrid INTO mat_wendat_dbrid;

       --- Eingangsrechnungsposition anlegen
         PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);
       --- Variante 4. Ende

   --- Verkauf art_welle = 'W.13.N-272.371 /C' anlegen
       mat_pos    := TSystem.Settings__GetInteger('AG_POS_WIDTH');
       mat_ag_nr  := getnumcirclenr('eauftg');

    --- Dokument für Auftrag anlegen
      mat_ltd_dokunr := nextval('auftg_ag_dokunr_seq');

    --- Variante 1: ag_mcv = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc, ag_vkp_mce = tartikel.me__art__artmgc__m_id__by__ak_standard_mgc
      --- Auftrag anlegen
        mat_stk := 20;
        mat_ag_preis  := 400;
        INSERT INTO auftg
          (ag_astat, ag_nr    , ag_pos, ag_dokunr, ag_lkn      , ag_krzl       , ag_krzf       , ag_kontakt  , ag_bdat     , ag_aknr  , ag_stk , ag_stkres , ag_datum    , ag_preis    , ag_mcv                    , ag_vkp,  ag_vkp_mce               , ag_kdatum        , ag_aldatum       , ag_steucode, ag_ustpr, ag_prkl, ag_kukl, ag_kurs, insert_by   , insert_date)
        VALUES
          ('E'     , mat_ag_nr, mat_pos, mat_ltd_dokunr, adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, current_user, current_date, art_welle, mat_stk, mat_stk   , current_date, mat_ag_preis, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), 0     , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), current_date + 21, current_date + 19, 3          , 19      , 1      , 1      , 1      , current_user, current_date)
        RETURNING ag_id INTO mat_ag_id;
        mat_pos := mat_pos + TSystem.Settings__GetInteger('AG_POS_WIDTH');
      --- Lagerzugang
          INSERT INTO wendat
          (w_aknr   , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang  , w_zug_mec     , insert_by, insert_date)
        VALUES
          (art_welle, current_date - 120, 'H3 | R2', 'R2'    , 'H3'        , '297'   , mat_stk, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), current_user, current_date)
        RETURNING dbrid INTO mat_wendat_dbrid;

      --- Lagerabgang für angelegte Verkaufsauftrag
        INSERT INTO lifsch
          (l_krz         , l_krzl         , l_krzf       , l_aknr   , l_ag_id  , l_ldat      , l_lgort  , l_lgchnr, l_abg_mec                 , l_abgg , insert_by, insert_date)
        VALUES
          (adk_kunde_getr, adk_kunde_getr, adk_kunde_getr, art_welle, mat_ag_id, current_date, 'H2 | R1', '187'   , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle), mat_stk, current_user, current_date)
        RETURNING dbrid INTO mat_lifsch_dbrid;
      --- Lieferscheinkopf anlegen
        mat_beld_dokunr := getnumcirclenr('lifsch');
        PERFORM TBeleg.LiefDokFromLagAb(mat_lifsch_dbrid, mat_beld_dokunr);
      --- Lieferscheinpos. anlegen
        mat_lfs_pos_id := TBeleg.LiefPosFromLagAb(mat_lifsch_dbrid, mat_beld_dokunr, mat_stk);
      --- Rechnungkopf anlegen
        mat_be_bnr := tfaktura.belkopf__from_adk__create(adk_kunde_getr, 'R', 1);
      --- Rechnungpos. anlegen
        PERFORM tfaktura.belzeil__from_lifsch__create(mat_be_bnr, mat_beld_dokunr, mat_lfs_pos_id);
      --- Variante 1. Ende

    -------------------------------------------------------------------------------------
    --- Anfrageverwaltung. Anfrage erstellen
     INSERT INTO anfrage (anf_nr) VALUES (getnumcirclenr('anfrage'))
     RETURNING anf_nr INTO anfnr;

     ---   'ZERSP'
     --- Anfragelieferant anlegen
     INSERT INTO anflief (alief_anf_nr, alief_lkn) VALUES (anfnr, adk_lief_zersp)
     RETURNING alief_id INTO aang_alief_id;

     --- Steuercode, Steuerprozent
     SELECT A1_WUCO, steu_proz INTO aang_steucode1, aang_steuproz1 FROM adk1 JOIN steutxt ON steu_z = a1_wuco WHERE a1_krz = adk_lief_zersp;

     --- Artikel Zusatztexte
     SELECT aArt_txt, aArt_txt_rtf    -- Laut Erzeugungsskript 'Angebotstext, vorgefüllt aus Anfragepositionstext, bearbeitbar, übernommen in Bestellung'
      INTO akbtxt, akbtxtrtf FROM anfart WHERE aart_id = aang_aart_id;

     -----
     --- 'STAHL'
     --- Anfragelieferant anlegen
     INSERT INTO anflief (alief_anf_nr, alief_lkn) VALUES (anfnr, adk_lief_stahl)
     RETURNING alief_id INTO aang_alief_id;

     --- Steuercode, Steuerprozent
     SELECT A1_WUCO, steu_proz INTO aang_steucode1, aang_steuproz1 FROM adk1 JOIN steutxt ON steu_z = a1_wuco WHERE a1_krz = adk_lief_stahl;

   -----

 END $$ LANGUAGE plpgsql;

DO $$
  DECLARE
  banf_pjnr       VARCHAR;
  vtrnr     VARCHAR(40);
  vtppos      INTEGER;
  aknr      VARCHAR(40) := 'W.13.N-999.999/TEST';
  vtpmce      INTEGER;
  vertrag_pos_dbrid   VARCHAR(32);
  vertrag_dbrid   VARCHAR(32);
  abk_dbrid   VARCHAR(32);
  abix      INTEGER;
  mat_aknr    VARCHAR(40) := 'W-9999-SF.99MM/TEST';
 BEGIN

   vtpmce := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(aknr);

   --Projekt anlegen
   banf_pjnr := getnumcirclenr('anl');

   INSERT INTO anl (an_nr    , an_bez                                             , an_best, an_kund, an_lief, an_inst, an_hest, an_sortkrz)
   VALUES          (banf_pjnr, 'Entwicklung Welle W.13.N-999.999/TEST : Werkzeugbau', 'DEMO' , 'DEMO' , '#'    , '#'    , 'DEMO' , 'DEMO'    );

   vtrnr := getnumcirclenr('vertrag');
   INSERT INTO vertrag
     (vtr_nr, vtr_art            , vtr_gegenstand  , vtr_bez  , vtr_krz, vtr_an_nr, vtr_apint,  vtr_nr_ext , vtr_apext, vtr_abschluss   , vtr_beginn       , vtr_ende         , vtr_kuendfrist, vtr_kuendfrist_interval, vtr_verlfrist, vtr_verlfrist_interval, vtr_laufverl, vtr_laufverl_interval, vtr_wert_kost, vtr_wert_erl)
   VALUES
     (vtrnr , 'vertrag_allgemein', 'Leasingvertrag', 'Leasing', 'GLU'  , banf_pjnr, 'DEMO'   , 'V.referenc', 'DEMO'   , current_date + 1, current_date + 10, current_date + 30, 15            , '1 day'                , 1            , '1 mon'               , 2           , '1 mon'              , 15000        , 2200)
   RETURNING dbrid INTO vertrag_dbrid;

   --- Vertragspositionen
   vtppos := COALESCE((SELECT Max(vtp_pos) + 10 FROM vertrag_pos WHERE vtp_vtr_nr = vtrnr), 10);
   INSERT INTO vertrag_pos
     (vtp_vtr_nr, vtp_pos, vtp_type, vtp_ak_nr, vtp_bez          , vtp_qty, vtp_mce, vtp_price)
   VALUES
     (vtrnr     , vtppos , 'A'     , aknr     , 'Lieferung Art A', 10     , vtpmce , 100)
   RETURNING dbrid INTO vertrag_pos_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid    , cyc_src_key  , cyc_begin   , cyc_end         , cyc_interval, cyc_multi)
   VALUES
     (vertrag_pos_dbrid, 'vertrag_pos', current_date, current_date + 7, '7 days'    , 1);

   vtppos := COALESCE((SELECT Max(vtp_pos) + 10 FROM vertrag_pos WHERE vtp_vtr_nr = vtrnr), 10);
   INSERT INTO vertrag_pos
     (vtp_vtr_nr, vtp_pos, vtp_type, vtp_ak_nr, vtp_bez         , vtp_qty, vtp_mce, vtp_price)
   VALUES
     (vtrnr     , vtppos , 'E'     , aknr     , 'Eigenprodukt A', 3      , vtpmce , 100)
   RETURNING dbrid INTO vertrag_pos_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid    , cyc_src_key  , cyc_begin       , cyc_end          , cyc_interval, cyc_multi)
   VALUES
     (vertrag_pos_dbrid, 'vertrag_pos', current_date + 3, current_date + 10, '1 days'    , 5);
   ---

   INSERT INTO abk (ab_ap_nr        , ab_tablename, ab_dbrid     , ab_askix, ab_at       , ab_et)
   VALUES          ('RECHNUNG LEGEN', 'vertrag'   , vertrag_dbrid, 0       , current_date + 2, current_date + 2)
   RETURNING dbrid INTO abk_dbrid;
   SELECT ab_ix INTO abix FROM abk WHERE dbrid = abk_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid, cyc_src_key, cyc_begin       , cyc_end         , cyc_interval, cyc_multi)
   VALUES
     (abk_dbrid    , 'abk'      , current_date + 1, current_date + 5, '1 days'    , 5);

   --- Projekt -< Arbeitsgang
   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (10  , abix    , current_date, current_date + 2, 'FRA-001', current_user     , false  , true   , 'Rechnung legen');

   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (20  , abix    , current_date, current_date + 2, 'GLU-001', current_user     , true   , false  , 'Rechnung legen');
   ---

   INSERT INTO abk (ab_ap_nr            , ab_tablename, ab_dbrid     , ab_askix, ab_at       , ab_et)
   VALUES          ('JÄHRLICHER WARTUNG TEST', 'vertrag'   , vertrag_dbrid, 0       , current_date -1, current_date + 1)
   RETURNING dbrid INTO abk_dbrid;
   SELECT ab_ix INTO abix FROM abk WHERE dbrid = abk_dbrid;

   INSERT INTO cycles
     (cyc_src_dbrid, cyc_src_key, cyc_begin    , cyc_end          , cyc_interval, cyc_multi)
   VALUES
     (abk_dbrid    , 'abk'      , current_date , current_date + 2, '1 days'    , 5);

   --- Projekt -< Arbeitsgang
   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (10  , abix    , current_date, current_date + 2, 'FRA-001', current_user     , false  , true   , 'Rechnung legen');

   INSERT INTO ab2 (a2_n, a2_ab_ix, a2_at       , a2_et           , a2_ks    , a2_v_ll_dbusename, a2_ausw, a2_ende, a2_subject)
   VALUES          (20  , abix    , current_date, current_date + 2, 'GLU-001', current_user     , true   , false  , 'Rechnung legen');
   ---
   --- Material
   INSERT INTO auftg(ag_astat, ag_nr         , ag_kontakt  , ag_aknr , ag_stk, ag_mcv                                                       , ag_prkl, ag_kukl, ag_kurs, ag_parentabk, ag_postxt)
   VALUES           ('I'     , 'VT-' || vtrnr, current_user, mat_aknr, 2     , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 1      , 1      , 1      , abix        , 'ADD');
   ---

 END $$;
SELECT true;


SELECT true;
